// <copyright file="BoardInputSettings.cs" company="Harris Hill Products Inc.">
//     Copyright (c) Harris Hill Products Inc. All rights reserved.
// </copyright>

namespace Board.Input
{
    using UnityEngine;
    
    /// <summary>
    /// Encapsulates all input settings for the Board platform.
    /// </summary>
    [CreateAssetMenu(fileName = "BoardInputSettings", menuName = "Board/Input Settings")]
    public class BoardInputSettings : ScriptableObject
    {
        [SerializeField] private float m_TranslationSmoothing = 0.5f;
        [SerializeField] private float m_RotationSmoothing = 0.5f;
        [SerializeField] private int m_Persistence = 4;
        [SerializeField] private string m_GlyphModelFilename;

        /// <summary>
        /// Gets the Translation Smoothing setting value.
        /// </summary>
        public float translationSmoothing => m_TranslationSmoothing;
        
        /// <summary>
        /// Gets the Rotation Smoothing setting value.
        /// </summary>
        public float rotationSmoothing => m_RotationSmoothing;
        
        /// <summary>
        /// Gets the Persistence setting value.
        /// </summary>
        public int persistence => m_Persistence;
        
        /// <summary>
        /// Gets the Glyph Model Filename setting value.
        /// </summary>
        public string glyphModelFilename => m_GlyphModelFilename;
    }
}
